function P83_iv
% Problem 8.3 :	Double-Well Potential System
% iv. Poincare section for different initial conditions
%     and the amplitude of external force

% Define some parameters
x01=[-0.05 0];          % First initial condition
x02=[-0.05 -0.05];      % Second initial condition
F=[0.18 0.40];          % Amplitude of external force
% Create figure
figure(1);
for i=1:length(F)
    % Solve equation of motion with the first initial conditions
    [T1,X1]=ode45(@(t,x)DoubleWell(t,x,F(i)),[0:2*pi:20000],x01);
    % Plot phase plane for the first initial conditions
    subplot(2,2,i*2-1); plot(X1(:,1),X1(:,2),'r.');
    grid on; axis tight;
    set(gca,'FontSize',14);
    xlabel('\bfLateral Position (a.u.)');
    ylabel('\bfLateral Velocity (a.u.)');
    title(['\bfPoincare Section with x_0=-0.05&v_0=0 for F=' num2str(F(i))]);
    % Solve equation of motion with the second initial conditions
    [T2,X2]=ode45(@(t,x)DoubleWell(t,x,F(i)),[0:2*pi:20000],x02);
    % Plot phase plane for the second initial conditions
    subplot(2,2,i*2); plot(X2(:,1),X2(:,2),'b.');
    grid on; axis tight;
    set(gca,'FontSize',14);
    xlabel('\bfLateral Position (a.u.)');
    ylabel('\bfLateral Velocity (a.u.)');
    title(['\bfPoincare Section with x_0=-0.05&v_0=-0.05 for F=' num2str(F(i))]);
end
end

function dx=DoubleWell(t,x,F)
dx(1,1)=x(2);
dx(2,1)=F*cos(t)-0.25*x(2)+x(1)-x(1)^3;
end